/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.gametest;

import com.blamejared.crafttweaker.gametest.TestModifier;
import java.lang.reflect.Method;

public class Modifier {
    private boolean implicitSuccession = false;

    private Modifier() {
    }

    public static Modifier empty() {
        return new Modifier();
    }

    public static Modifier from(Method method) {
        Modifier mod = Modifier.empty();
        if (!method.isAnnotationPresent(TestModifier.class)) {
            return mod;
        }
        TestModifier modifier = method.getAnnotation(TestModifier.class);
        mod.setImplicitSuccession(modifier.implicitSuccession());
        return mod;
    }

    public static Modifier from(TestModifier modifier) {
        Modifier mod = Modifier.empty();
        mod.setImplicitSuccession(modifier.implicitSuccession());
        return mod;
    }

    public Modifier merge(Modifier modifier) {
        Modifier mod = Modifier.empty();
        mod.setImplicitSuccession(this.isImplicitSuccession() & modifier.isImplicitSuccession());
        return mod;
    }

    public Modifier merge(TestModifier modifier) {
        return this.merge(Modifier.from(modifier));
    }

    public boolean isImplicitSuccession() {
        return this.implicitSuccession;
    }

    public void setImplicitSuccession(boolean implicitSuccession) {
        this.implicitSuccession = implicitSuccession;
    }
}

